#version 330

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in float brightness_geom[];
in float particle_geom_size[];
in float texture_index_geom[];

out vec2 uv;
out float brightness_frag;
out float texture_index_frag;

uniform ivec2 screen_size;

void main()
{
    vec4 in_position = gl_in[0].gl_Position;
    float tex_index = texture_index_geom[0];
    float brightness_level = brightness_geom[0];
    vec2 d = vec2(0.5 * particle_geom_size[0]);

    vec2 pixel_offset = vec2(0.0);

    texture_index_frag = tex_index;
    brightness_frag = brightness_level;

    gl_Position = in_position + vec4((vec2( d.x, -d.y) + pixel_offset), vec2(0.0));
    uv = vec2(1.0, 1.0);
    EmitVertex();
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;

    gl_Position = in_position + vec4((vec2( d.x,  d.y) + pixel_offset), vec2(0.0));
    uv = vec2(1.0, 0.0);
    EmitVertex();
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;

    gl_Position = in_position + vec4((vec2(-d.x, -d.y) + pixel_offset), vec2(0.0));
    uv = vec2(0.0, 1.0);
    EmitVertex();
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;

    gl_Position = in_position + vec4((vec2(-d.x,  d.y) + pixel_offset), vec2(0.0));
    uv = vec2(0.0, 0.0);
    EmitVertex();

    EndPrimitive();
}
